implementation module windowInternal;

import StdClass,StdInt,StdBool,StdString,StdList,StdFunc;
import	pointer, structure, windows, quickdraw, controls;
import	commonDef, ioState, windowInternal2, windowAccess;
from	Picture import MakePicture, MakeMacPicture,::Vector;
import calcScrollUpdate;
import ScrollBars;

::	DeltaControl :== *Toolbox -> *Toolbox;

//	Scrolling windows.

ScrollingAreaIsVisible :: !WindowPtr !Vector !(!Int,!Int) !*Toolbox -> (![Rect],!*Toolbox);
ScrollingAreaIsVisible wPtr (dx,dy) (width,height) tb
|	frameVisible			= ([],			QDisposeRgn invisRgn tb5);		// The whole frame is visible
|	emptyWrong				= ([],			QDisposeRgn wrongRgn tb9);		// The scrolled part remains invisible
							= ([wrongRect],	QDisposeRgn wrongRgn tb10);		// The bounding rect of the new visible part
	where {
		frameWidth			= width -ScrollBarWidth;
		frameHeight			= height-ScrollBarWidth;
		scrollframe			= (0,0, frameWidth,frameHeight);
		(visRgn,tb1)		= LoadLong (wPtr+24) tb;						// Load the visRgnHandle
		(frameRgn,tb2)		= QNewRgn tb1;
		tb3					= QRectRgn frameRgn scrollframe tb2;			// Set the whole window frame
		(invisRgn,tb4)		= QDiffRgn frameRgn visRgn frameRgn tb3;		// whole window - visRgn = invisRgn
		(frameVisible,tb5)	= QEmptyRgn invisRgn tb4;
		tb6					= QOffsetRgn invisRgn dx dy tb5;				// Scroll the invisRgn
		(newRgn,tb7)		= QNewRgn tb6;
		(wrongRgn,tb8)		= QSectRgn invisRgn visRgn invisRgn tb7;		// Intersect scrolled invisRgn with visRgn
		(emptyWrong,tb9)	= QEmptyRgn wrongRgn tb8;
		(wrongRect,tb10)	= loadRgnBBox wrongRgn tb9;
		
		loadRgnBBox :: !RgnHandle !*Toolbox -> (!Rect,!*Toolbox);
		loadRgnBBox rgnH tb
		=	((left,top, right,bottom),tb5);
			where {
				(rgnPtr,tb1)	= LoadLong rgnH tb;
				rectPtr			= 2+rgnPtr;									// rgnBBox offset
				(top,   tb2)	= LoadWord rectPtr		tb1;
				(left,  tb3)	= LoadWord (rectPtr+2)	tb2;
				(bottom,tb4)	= LoadWord (rectPtr+4)	tb3;
				(right, tb5)	= LoadWord (rectPtr+6)	tb4;
			};
	};

MoveRect :: !Vector !Rect -> Rect;
MoveRect (dx,dy) (left,top, right,bottom) = (left+dx,top+dy, right+dx,bottom+dy);

RectToRectangle :: !Rect -> Rectangle;
RectToRectangle (left,top, right,bottom) = ((left,top),(right,bottom));

NewUpdateArea wPtr hBar vBar pict updArea new zoom
	:==	(wPtr, hBar, vBar, pict, AppendUpdateAreas new updArea, zoom);

Scroll_window :: !Window !Int !Int !Int !Int !(UpdateFunction *s) !*s !*Toolbox
	->	(!Window, !*s, !*Toolbox);
Scroll_window window oldHpos oldVpos hPos vPos f s tb
|	oldHpos == hPos	= Scroll_window_vertical	window oldHpos oldVpos vPos		 f s tb;
|	oldVpos == vPos	= Scroll_window_horizontal	window oldVpos oldHpos hPos		 f s tb;
					= Scroll_window_diagonal	window oldHpos oldVpos hPos vPos f s tb;

Scroll_window_vertical :: !Window !Int !Int !Int !(UpdateFunction *s) !*s !*Toolbox
	->	(!Window, !*s, !*Toolbox);
Scroll_window_vertical window=:(wPtr, hBar, vBar, pict, upd, zoom) hPos oldVpos vPos f s tb
|	dv1 > 0 && dv1 < h2	= Draw_window down [(0,h2 - dv1,w2,h2):wrongRects]	DrawNoControls f s scroll;
|	dv2 > 0 && dv2 < h2	= Draw_window up   [(0,0,w2,dv2):wrongRects]		DrawNoControls f s scroll;
|	dv1 <> 0			= Draw_window page [rect]							DrawNoControls f s tb2;
						= (window, s, tb2);
	where {
		rect			= (0, 0, w2, h2);
		dv1				= vPos - oldVpos;			dv2		= oldVpos - vPos;
		w2				= w - ScrollBarWidth;		h2		= h - ScrollBarWidth;
		hPos`			= hPos + w2;				vPos`	= vPos + h2;
		(w,h)			= size;
		(size,tb1)		= Window_size wPtr tb;
		(wrongRects,tb2)= ScrollingAreaIsVisible wPtr (0,dv2) (w,h) tb1;
		wrongAreas		= map (RectToRectangle o MoveRect (hPos,vPos)) wrongRects;
		scroll			= DoScroll wPtr w2 h2 0 dv2 tb2;
		down			= NewUpdateArea wPtr hBar vBar pict upd [((hPos,vPos` - dv1),(hPos`,vPos`)):wrongAreas] zoom;
		up				= NewUpdateArea wPtr hBar vBar pict upd [((hPos,vPos), (hPos`,vPos + dv2)) :wrongAreas] zoom;
		page			= (wPtr, hBar, vBar, pict, [((hPos, vPos), (hPos`, vPos`))], zoom);
	};

Scroll_window_horizontal :: !Window !Int !Int !Int !(UpdateFunction *s) !*s !*Toolbox
	->	(!Window, !*s, !*Toolbox);
Scroll_window_horizontal window=:(wPtr, hBar, vBar, pict, upd, zoom) vPos oldHpos hPos f s tb
|	dh1 > 0 && dh1 < w2	= Draw_window right [(w2-dh1,0, w2,h2):wrongRects]	DrawNoControls f s scroll;
|	dh2 > 0 && dh2 < w2	= Draw_window left  [(0,0, dh2,h2):wrongRects]		DrawNoControls f s scroll;
|	dh1 <> 0			= Draw_window page  [rect]							DrawNoControls f s tb2;
						= (window, s, tb2);
	where {
		rect			= (0, 0, w2, h2);
		dh1				= hPos - oldHpos;			dh2		= oldHpos - hPos;
		w2				= w - ScrollBarWidth;		h2		= h - ScrollBarWidth;
		hPos`			= hPos + w2;				vPos`	= vPos + h2;
		(w,h)			= size;
		(size, tb1)		= Window_size wPtr tb;
		(wrongRects,tb2)= ScrollingAreaIsVisible wPtr (dh2,0) (w,h) tb1;
		wrongAreas		= map (RectToRectangle o MoveRect (hPos,vPos)) wrongRects;
		scroll			= DoScroll wPtr w2 h2 dh2 0 tb2;
		right			= NewUpdateArea wPtr hBar vBar pict upd [((hPos` - dh1,vPos),(hPos`,vPos`)):wrongAreas] zoom;
		left			= NewUpdateArea wPtr hBar vBar pict upd [((hPos,vPos), (hPos + dh2,vPos`)) :wrongAreas] zoom;
		page			= (wPtr, hBar, vBar, pict, [((hPos, vPos), (hPos`, vPos`))], zoom);
	};

Scroll_window_diagonal :: !Window !Int !Int !Int !Int !(UpdateFunction *s) !*s !*Toolbox
	->	(!Window, !*s, !*Toolbox);
Scroll_window_diagonal window=:(wPtr, hBar, vBar, pict, upd, zoom) oldHpos oldVpos hPos vPos f s tb
|	pos_dh2 && pos_dv2 && l_dh2 && l_dv2	= DiagScroll l_u r_l_u wrongRects w2 h2 dh2 dv2 window1 f s tb2;
|	pos_dh1 && pos_dv2 && l_dh1 && l_dv2	= DiagScroll r_u r_r_u wrongRects w2 h2 dh2 dv2 window1 f s tb2;
|	pos_dh1 && pos_dv1 && l_dh1 && l_dv1	= DiagScroll r_d r_r_d wrongRects w2 h2 dh2 dv2 window1 f s tb2;
|	pos_dh2 && pos_dv1 && l_dh2 && l_dv1	= DiagScroll l_d r_l_d wrongRects w2 h2 dh2 dv2 window1 f s tb2;
											= Draw_window page [(0,0, w2,h2)] DrawNoControls f s tb2;
	where {
		dh1 			= hPos - oldHpos;			pos_dh1	= dh1 > 0;		l_dh1 = dh1 < w2;
		dh2 			= oldHpos - hPos;			pos_dh2	= dh2 > 0;		l_dh2 = dh2 < w2;
		dv1				= vPos - oldVpos;			pos_dv1	= dv1 > 0;		l_dv1 = dv1 < h2;
		dv2				= oldVpos - vPos;			pos_dv2	= dv2 > 0;		l_dv2 = dv2 < h2;
		w2				= w - ScrollBarWidth;		h2		= h - ScrollBarWidth;
		hPos`			= hPos + w2;				vPos`	= vPos + h2;
		(w,h)			= size;
		(size,tb1)		= Window_size wPtr tb;
		(wrongRects,tb2)= ScrollingAreaIsVisible wPtr (dh2,dv2) (w,h) tb1;
		wrongAreas		= map (RectToRectangle o MoveRect (hPos,vPos)) wrongRects;
		window1			= NewUpdateArea wPtr hBar vBar pict upd wrongAreas zoom;
		left_top		= (hPos,  vPos);
		right_bot		= (hPos`, vPos`);
		l_u				= ((left_top, (hPos + dh2, vPos`)),((hPos + dh2, vPos), (hPos`, vPos + dv2)));
		r_l_u			= ((0, 0, dh2, h2), (dh2, 0, w2, dv2));
		r_u				= (((hPos` - dh1, vPos), right_bot), (left_top, (hPos` - dh1, vPos + dv2)));
		r_r_u			= ((w2 - dh1, 0, w2, h2), (0, 0, w2 - dh1, dv2));
		r_d				= (((hPos` - dh1, vPos), right_bot), ((hPos, vPos` - dv1), (hPos` - dh1, vPos`)));
		r_r_d			= ((w2 - dh1, 0, w2, h2), (0, h2 - dv1, w2 - dh1, h2));
		l_d				= ((left_top, (hPos + dh2, vPos`)), ((hPos + dh2, vPos` - dv1), right_bot));
		r_l_d			= ((0, 0, dh2, h2), (dh2, h2 - dv1, w2, h2));
		page			= (wPtr, hBar, vBar, pict, [((hPos, vPos), (hPos`, vPos`))], zoom);
	};

DiagScroll :: !(!Rectangle, !Rectangle) !(!Rect, !Rect) ![Rect] !Int !Int !Int !Int !Window
		!(UpdateFunction *s) !*s !*Toolbox
	->	(!Window, !*s, !*Toolbox);
DiagScroll (upd1, upd2) (rect1, rect2) wrongRects w h dh dv window=:(wPtr, hBar, vBar, pict, updArea, zoom) f s tb
	= 	Draw_window window3 [rect2:wrongRects] DrawNoControls f s2 tb2;
	where {
		window3				= (wPtr2, hBar2, vBar2, pict2, AppendUpdateAreas [upd2] updArea2, zoom2);
		(wPtr2, hBar2, vBar2, pict2, updArea2, zoom2)= window2;
		(window2, s2, tb2)	= Draw_window window1 [rect1:wrongRects] DrawNoControls f s scroll;
		window1				= (wPtr, hBar, vBar, pict, AppendUpdateAreas [upd1] updArea, zoom);
		scroll				= DoScroll wPtr w h dh dv tb;
	};

DoScroll :: !WindowPtr !Int !Int !Int !Int !*Toolbox -> *Toolbox;
DoScroll wPtr w h dh dv tb
	=	tb3;
	where {
		(newRgn,tb1)= QNewRgn tb;
		tb2			= InGrafport2 wPtr (QScrollRect (0,0, w,h) dh dv newRgn) tb1;
		tb3			= QDisposeRgn newRgn tb2;
	};

//	Dragging windows.

Drag_window	:: !WindowPtr !Int !Int !*Toolbox -> *Toolbox;
Drag_window wPtr h v tb
	=	DragWindow wPtr h v  (sL, sT, dec sR, dec sB) tb1;
	where {
		(sL, sT, sR, sB, tb1)= QScreenRect tb;
	};


//	(Re)Drawing windows.

DrawScrollBarsAndGrowIcon :: !WindowPtr !Int !Int !DrawMode !*Toolbox -> *Toolbox;
DrawScrollBarsAndGrowIcon wPtr w h HasControls tb
	=	tb5;
	where {
		tb1			= QEraseRect (w-15,0,    w,h-15)	tb;
		tb2			= QEraseRect (0,   h-15, w,h   )	tb1;
		(rgn, tb3)	= LoadLong	 (wPtr+24)				tb2;
		tb4			= UpdtControl wPtr rgn				tb3;
		tb5			= DrawGrowIcon wPtr					tb4;
	};
DrawScrollBarsAndGrowIcon _ _ _ _ tb = tb;

ChangePicture :: ![DrawFunction] !*Toolbox -> *Toolbox;
ChangePicture fs mp = MakeMacPicture (ChangePicture` fs (MakePicture mp));

ChangePicture`	:: ![DrawFunction] !Picture -> Picture;
ChangePicture` [f : fs] picture = ChangePicture` fs (f picture);
ChangePicture` fs       picture = picture;

F :: *s (UpdateFunction *s) UpdateArea !*Toolbox -> (!*Toolbox, !*s);
F s f updArea tb
	= 	(MakeMacPicture (ChangePicture` fs (MakePicture tb)), s1);
		where {
		(s1, fs)= f updArea s;
		};

Draw_in_window :: !Window !DrawMode ![DrawFunction] !*Toolbox -> (!Window, !*Toolbox);
Draw_in_window	window=:(wPtr,hBar=:(hControl,hScroll,hMax),vBar=:(vControl,vScroll,vMax),pict,updArea,zoom)
				mode fs tb
	=	(window, tb11);
	where {
		(port,	tb1)	= QGetPort tb;
		tb2				= QSetPort wPtr tb1;
		(newRgn,tb3)	= QNewRgn tb2;
		(rgn,	tb4)	= QGetClip newRgn tb3;
		(size,	tb5)	= Window_size wPtr tb4;
		(w, h)			= size;
		(vThumb,tb6)	= GetScrollBarValue vControl vMax tb5;
		(hThumb,tb7)	= GetScrollBarValue hControl hMax tb6;
		tb8				= QClipRect (DrawModeClipRect hThumb vThumb w h mode) tb7;
		tb9				= QSetOrigin hThumb vThumb tb8;
		tb10			= ChangePicture fs tb9;
		tb11			= QDisposeRgn rgn (QSetPort port (QSetClip rgn (QSetOrigin 0 0 tb10)));
		};

DrawModeClipRect :: !Int !Int !Int !Int !DrawMode -> Rect;
DrawModeClipRect x y w h HasNoControls	= (x,y, x+w,y+h);
DrawModeClipRect x y w h hasControls	= (x,y, x+w-ScrollBarWidth,y+h-ScrollBarWidth);

Draw_window :: !Window ![Rect] !DrawMode !(UpdateFunction *s) !*s !*Toolbox -> (!Window, !*s, !*Toolbox);
Draw_window (wPtr,hBar=:(hControl,hScroll,hMax),vBar=:(vControl,vScroll,vMax),pict,updArea,zoom) rects mode f s tb
	=	((wPtr, hBar, vBar, pict, [], zoom), s1, tb13);
	where {
		(port, tb1)		= QGetPort tb;
		tb2				= QSetPort wPtr tb1;
		(newRgn,tb3)	= QNewRgn tb2;
		(rgn, tb4)		= QGetClip newRgn tb3;
		(size, tb5)		= Window_size wPtr tb4;
		(w, h)			= size;
		tb6				= DrawScrollBarsAndGrowIcon wPtr w h mode tb5;
		(hThumb, tb7)	= GetScrollBarValue hControl hMax tb6;
		(vThumb, tb8)	= GetScrollBarValue vControl vMax tb7;
		(clipRgn,tb9)	= CreateClipRgn (map (MoveRect (hThumb,vThumb)) rects) tb8;
		tb10			= QSetClip clipRgn tb9;
		tb11			= QSetOrigin hThumb vThumb tb10;
		(tb12, s1)		= F s f updArea tb11;
		tb13			= QDisposeRgn rgn (QDisposeRgn clipRgn (QSetPort port (QSetClip rgn (QSetOrigin 0 0 tb12))));
		
		CreateClipRgn :: ![Rect] !*Toolbox -> (!RgnHandle,!*Toolbox);
		CreateClipRgn rects tb
		=	(clipRgn,tb4);
			where {
				(clipRgn,tb1)	= QNewRgn tb;
				(aidRgn,tb2)	= QNewRgn tb1;
				tb3				= CreateClipRgn` rects clipRgn aidRgn tb2;
				tb4				= QDisposeRgn aidRgn tb3;
			};
		
		CreateClipRgn` :: ![Rect] !RgnHandle !RgnHandle !*Toolbox -> *Toolbox;
		CreateClipRgn` [rect:rects] clipRgn aidRgn tb
		=	CreateClipRgn` rects clipRgn1 aidRgn tb2;
			where {
				tb1				= QRectRgn aidRgn rect tb;
				(clipRgn1,tb2)	= QUnionRgn clipRgn aidRgn clipRgn tb1;
			};
		CreateClipRgn` _ _ _ tb
		=	tb;
	};


//	Rules for ControlHandling.

DoHilitControl :: !ControlHandle !Window !Int !DeltaControl !(UpdateFunction *s) !*s !*Toolbox
	->	(!Window, !*s, !*Toolbox);
DoHilitControl control window part f update s tb
	= 	(window1, s1, HiliteControl control 0 tb2);
	where {
		(window1, s1, tb2)	= DoControl control window part f update s tb1;
		tb1					= HiliteControl control part tb;
	};

DoControl :: !ControlHandle !Window !Int !DeltaControl !(UpdateFunction *s) !*s !*Toolbox
	->	(!Window, !*s, !*Toolbox);
DoControl control window=:(wPtr, hBar, vBar, pict, updArea, zoom) part f update s tb
	=	DoControl2 control window part hPos vPos f update s tb2;
	where {
		(hControl, _, hMax)	= hBar;
		(vControl, _, vMax)	= vBar;
		(hPos, tb1)			= GetScrollBarValue hControl hMax tb;
		(vPos, tb2)			= GetScrollBarValue vControl vMax tb1;
	};

DoControl2 :: !ControlHandle !Window !Int !Int !Int !DeltaControl !(UpdateFunction *s) !*s !*Toolbox
	->	(!Window, !*s, !*Toolbox);
DoControl2 control window part oldHpos oldVpos f update s tb
	= 	DoControl3 control window part oldHpos oldVpos f update s (f tb);

DoControl3	:: !ControlHandle !Window !Int !Int !Int !DeltaControl !(UpdateFunction *s) !*s !*Toolbox
	->	(!Window, !*s, !*Toolbox);
DoControl3 control window=:(wPtr, hBar, vBar, pict, updArea, zoom) part oldHpos oldVpos f update s tb
|	not mouseDown		= (doScroll, s1, tb4);
|	part1 == part
&&	control1 == control	= DoControl2 control doScroll part hPos vPos f update s1 tb6;
						= waitForMouseInControlPart control doScroll part f update s1 tb6;
	where {
		(hControl, _, hMax)	= hBar;
		(vControl, _, vMax)	= vBar;
		(hPos, tb1)					= GetScrollBarValue hControl hMax tb;
		(vPos, tb2)					= GetScrollBarValue vControl vMax tb1;
		(doScroll, s1, tb3)			= Scroll_window window oldHpos oldVpos hPos vPos update s tb2;
		(mouseDown, tb4)			= WaitMouseUp tb3;
		(mouse, tb5)				= InGrafport wPtr GetMousePosition tb4;
		(h1, v1) 					= mouse;
		(part1, control1, tb6)		= FindControl h1 v1 wPtr tb5;
	};

waitForMouseInControlPart :: !ControlHandle !Window !Int !DeltaControl !(UpdateFunction *s) !*s !*Toolbox
	-> (!Window, !*s, !*Toolbox);
waitForMouseInControlPart control window=:(wPtr, hBar, vBar, pict, updArea, zoom) part f update s tb
|	not mouseDown			= (window, s, tb1);
|	part1==part 
&&	control1==control		= DoControl3 control window part hPos vPos f update s tb5;
								with {
									(hControl,_,_)	= hBar;
									(vControl,_,_)	= vBar;
									(hPos, tb4)		= GetCtlValue hControl tb3;
									(vPos, tb5)		= GetCtlValue vControl tb4;
								};
							= waitForMouseInControlPart control window part f update s tb3;
	where {
		(mouseDown,tb1)			= WaitMouseUp tb;
		((h1,v1),tb2)			= InGrafport wPtr GetMousePosition tb1;
		(part1,control1,tb3)	= FindControl h1 v1 wPtr tb2;
	};

GetMousePosition :: !*Toolbox -> (!Point, !*Toolbox);
GetMousePosition tb
	=	((x,y),tb1);
	where {
		(x, y, tb1) = GetMouse tb;
	};

Wait_mouse_up :: !*Toolbox -> *Toolbox;
Wait_mouse_up tb
|	mouseDown	= Wait_mouse_up tb1;
				= tb1;
	where {
		(mouseDown, tb1) = WaitMouseUp tb;
	};

MoveThumb :: !ControlHandle !Window !Int !Int !(UpdateFunction *s) !*s !*Toolbox
	->	(!Window, !*s, !*Toolbox);
MoveThumb control window=:(wPtr, hBar, vBar, pict, updArea, zoom) h v update s tb
|	finalPart == InThumb	= Scroll_window window oldHpos oldVpos hPos vPos update s tb10;
							= (window, s, tb3);
	where {
		(hControl, hScroll, hMax)	= hBar;
		(vControl, vScroll, vMax)	= vBar;
		(oldHpos,	tb1)			= GetScrollBarValue hControl hMax tb;
		(oldVpos,	tb2)			= GetScrollBarValue vControl vMax tb1;
		(finalPart, tb3)			= TrackControl control h v 0 tb2;
		(curHpos,	tb4)			= GetScrollBarValue hControl hMax tb3;
		(cHMin,		tb5)			= GetScrollBarMin	hControl hMax tb4;
		(cHMax,		tb6)			= GetScrollBarMax	hControl hMax tb5;
		(curVpos,	tb7)			= GetScrollBarValue	vControl vMax tb6;
		(cVMin,		tb8)			= GetScrollBarMin	vControl vMax tb7;
		(cVMax,		tb9)			= GetScrollBarMax	vControl vMax tb8;
		hPos						= Align_thumb curHpos cHMin cHMax hScroll;
		vPos						= Align_thumb curVpos cVMin cVMax vScroll;
		tb10						= SetScrollBarValue vControl vPos vMax
									  (SetScrollBarValue hControl hPos hMax tb9);
	};

Align_thumb	:: !Int !Int !Int !Int -> Int;
Align_thumb thumb min max scroll
|	thumb == max	= thumb;
					= min + dThumb - (dThumb rem scroll);
	where {
		dThumb = thumb - min;
	};
